#!/opt/maint/venv/bin/python3
"""Removes domlogs for terminated accounts"""
# Vanessa V 12/21/12 (aka "the end of the world that didn't happen" day)

import os
import sys
import shutil
import yaml

LOG_DIR = '/var/log/apache2/domlogs/'

# Create a list of deleted domains
with open('/var/cpanel/deleteddomains.yaml', encoding='utf-8') as f:
    del_map = yaml.load(f, Loader=yaml.SafeLoader)

if del_map is None:
    del_map = {}

userdoms = set()
with open('/etc/userdomains', encoding='utf-8') as f:
    for line in f:
        userdoms.add(line.split(':')[0])

EXT_LIST = [
    '-smtpbytes_log',
    '-smtpbytes_log',
    '-bytes_log',
    '-bytes_log.offset',
    '.offsetftpbytes ',
    '.bkup',
    '-bkup2',
    '-ftp_log ',
    '-popbytes_log',
    '-imapbytes_log',
    '-ssl_log',
    '-ssl_data_log',
]

# For each domain, see if a domlogs entry exists


def try_remove(path):
    try:
        os.unlink(path)
    except OSError:
        return
    print('Deleted', path)


def main():
    for domain in del_map.keys():
        if domain is None or domain in userdoms:  # it was added back
            continue
        # remove leftover domlogs for domains which no longer exist
        dom_path = os.path.join(LOG_DIR, domain)
        try_remove(dom_path)
        for ext in EXT_LIST:
            ext_path = f'{dom_path}{ext}'
            try_remove(ext_path)
        # Find the user
        user = del_map[domain]['user']
        if user is None:
            continue
        # Remove the user's folder if it exists and the user does not
        user_logdir = os.path.join(LOG_DIR, user)
        users_file = os.path.join('/var/cpanel/users', user)
        if not os.path.exists(users_file) and os.path.isdir(user_logdir):
            try:
                shutil.rmtree(user_logdir)
                print('Deleted logs in', user_logdir)
            except (OSError, shutil.Error) as exc:
                print('Could not delete', user_logdir)
                print(exc, file=sys.stderr)


if __name__ == '__main__':
    main()
