class GDAssistant {
  backdropEl;
  containerEl;
  activateBtnEl;

  constructor() {
    this.init();
  }

  init() {
    this.backdropEl = document.getElementById("gd-assistant-backdrop");
    this.containerEl = document.getElementById("gd-assistant-container");
    this.addListeners();
  }

  addListeners() {
    document.addEventListener("click", (event: MouseEvent) => {
      if (
        (event.target as HTMLElement)?.parentElement?.classList?.contains(
          "gd-assistant-open"
        ) ||
        (event.target as HTMLElement)?.classList?.contains("gd-assistant-open")
      ) {
        event.preventDefault();
        this.containerEl.classList.toggle("gd-assistant-open");
      }
    });
    window.addEventListener("keydown", (event) => {
      // do something when a key is pressed
      if ((event.ctrlKey || event.metaKey) && event.key === "j") {
        event.preventDefault();
        this.containerEl.classList.toggle("gd-assistant-open");
        setTimeout(() => {
          (
            document.getElementById("gd-assistant-app") as HTMLIFrameElement
          )?.contentWindow?.document
            .getElementById("gd-assistant-chat-input")
            ?.focus();
        }, 100);
      }
    });

    this.backdropEl.addEventListener("click", (event) => {
      this.containerEl.classList.toggle("gd-assistant-open");
    });

    window.addEventListener("message", (event) => {
      if (event.data?.type === "assistantRedirect") {
        if (event.data.payload?.target === "_blank") {
          window.open(event.data.payload.url, "_blank");
        } else {
          window.location.href = event.data.payload.url;
        }
      } else if (event.data?.type === "toggleAssistant") {
        this.containerEl.classList.toggle("gd-assistant-open");
        window.focus();
      }
    });
  }
}

(function (window, document, $) {
  $(document).on("ready", () => new GDAssistant());
})(window, document, jQuery);
