<?php

namespace GoDaddy\WordPress\MWC\Core\JobQueue\Traits;

use GoDaddy\WordPress\MWC\Core\JobQueue\Contracts\QueueableJobContract;

/**
 * Trait for classes that hold queued jobs that are chained. {@see QueueableJobContract}.
 */
trait HasChainedJobsTrait
{
    /** @var class-string<QueueableJobContract>[] job class names, in the order they should be executed */
    public array $chained;

    /**
     * Constructor.
     *
     * @param class-string<QueueableJobContract>[] $chained
     */
    public function __construct(array $chained)
    {
        $this->chained = $chained;
    }
}
