<?php

/**
 * Plugin Name: GoDaddy WordPress Assistant
 * Description: Get help with your shop: create products, write articles, find documentation, and more. Powered by AI.
 * Version: 0.1.0
 * Author: GoDaddy
 */


namespace GoDaddy\MWC\WordPress;

if (class_exists('GoDaddy\MWC\WordPress\Assistant\Admin')) {
    return;
}

class Assistant {

    public function __construct() {
        $this->start();
    }

    public function start() {

        if (!defined('GD_ASSISTANT_URL')) {
            define('GD_ASSISTANT_URL', plugin_dir_url(__FILE__));
        }

        define('GD_ASSISTANT_VERSION', '0.1.0');

        if (!defined('GD_ASSISTANT_API_URL')) {
            define('GD_ASSISTANT_API_URL', 'https://ai-assistant.commerce.api.godaddy.com/graphqlexternal');
        }

        $this->loadFiles();
    }

    public function loadFiles() {
        if (defined('GD_ASSISTANT_LOCAL')) {
            require_once(dirname(__FILE__) . '/vendor/autoload.php');
        }
        require_once(dirname(__FILE__) . '/inc/class-api.php');
        require_once(dirname(__FILE__) . '/inc/class-admin.php');
        require_once(dirname(__FILE__) . '/inc/class-ai-prompt-event.php');
    }
}

new Assistant();
