<?php

namespace GoDaddy\WordPress\MWC\Core\JobQueue\Traits;

use GoDaddy\WordPress\MWC\Common\Events\Events;
use GoDaddy\WordPress\MWC\Core\JobQueue\Contracts\QueueableJobContract;
use GoDaddy\WordPress\MWC\Core\JobQueue\Events\QueuedJobDoneEvent;

/**
 * Trait for queueable jobs, to implement common methods in the {@see QueueableJobContract} interface.
 */
trait QueueableJobTrait
{
    /** @var class-string<QueueableJobContract>[] chain of job class names, in the order they should be run */
    protected array $chain;

    /**
     * Add an array of jobs (class names) to the queue.
     *
     * @param class-string<QueueableJobContract>[] $chain
     * @return $this
     */
    public function setChain(array $chain)
    {
        $this->chain = $chain;

        return $this;
    }

    /**
     * Job processed successfully.
     *
     * @return void
     */
    public function jobDone() : void
    {
        Events::broadcast(QueuedJobDoneEvent::getNewInstance($this->chain));
    }
}
