<?php

namespace GoDaddy\WordPress\MWC\Core\JobQueue\Traits;

use GoDaddy\WordPress\MWC\Core\JobQueue\Contracts\HasJobSettingsContract;
use GoDaddy\WordPress\MWC\Core\JobQueue\DataObjects\Contracts\JobSettingsContract;

/**
 * Trait for jobs that have settings. Implements common methods in {@see HasJobSettingsContract}.
 */
trait HasJobSettingsTrait
{
    /** @var JobSettingsContract settings for the current job */
    protected JobSettingsContract $jobSettings;

    /**
     * Sets the job settings against the handler.
     *
     * @param JobSettingsContract $jobSettings
     * @return $this
     */
    public function setJobSettings(JobSettingsContract $jobSettings)
    {
        $this->jobSettings = $jobSettings;

        return $this;
    }

    /**
     * Gets the batch settings.
     *
     * @return JobSettingsContract
     */
    public function getJobSettings() : JobSettingsContract
    {
        return $this->jobSettings;
    }
}
