<?php

namespace GoDaddy\MWC\WordPress\Assistant\Events;

use GoDaddy\WordPress\MWC\Common\Events\Contracts\EventBridgeEventContract;
use GoDaddy\WordPress\MWC\Common\Traits\IsEventBridgeEventTrait;

/**
 * event class.
 */
class AIPromptEvent implements EventBridgeEventContract {
    use IsEventBridgeEventTrait;
    /** @var string */
    protected $prompt;
    protected string $errorMessage;

    /** @var mixed */
    protected $response;

    /**
     * event constructor.
     *
     * @param mixed $response
     */
    public function __construct(string $prompt, $response, string $errorMessage = "") {
        $this->resource = 'ai-assistant-prompt';
        $this->prompt = $prompt;
        $this->action = "create";
        $this->response = $response;
        $this->errorMessage = $errorMessage;
    }

    /**
     * Gets the data for the event.
     *
     * @return array<string, mixed>
     */
    protected function buildInitialData(): array {
        return [
            'resource' => [
                'prompt' => $this->prompt,
                'functionName' => is_object($this->response) && isset($this->response->wpAssistant->value->function->name) ? $this->response->wpAssistant->value->function->name : null,
                'responseContent' => is_object($this->response) && isset($this->response->wpAssistant->value->content) ? $this->response->wpAssistant->value->content : null,
                'errorMessage' => $this->errorMessage,
            ]
        ];
    }
}
