<?php
if ( empty(get_included_files()) ) die("Direct access forbidden");

/* echo JSON data in a way jquery will understand when found in an HTML5 data-* attribute */
function echo_json_attrib($data){
  echo(str_replace('"', '&quot;', json_encode($data)));
}

function label_size($item, $size_mb){
  echo($item);
  if (is_numeric($size_mb)) {
    echo(' (');
    echo(round($size_mb / 1024, 2));
    echo('GB)');
  }
}

function show_switch($id, $enabled, $enabled_text = "Enabled", $disabled_text = "Disabled") {
  $text = ($enabled ? $enabled_text : $disabled_text);
  $state = ($enabled ? 'on' : 'off');
  echo <<<EOF
<span>
  <div id="triggerswitch-{$id}"
    class="switchdiv_{$id} cjt2-toggle-switch switch-{$state}"
    onclick="toggle_switch_state('{$id}');"
    data-switch-id="{$id}">
    <span id="switchlabel_{$id}" data-enabled-text="{$enabled_text}" data-disabled-text="{$disabled_text}" class="toggle-switch-label toggle-switch-label-left">{$text}</span>
    <div class="toggle-switch">
      <div id="{$id}" class="switchdiv_{$id} toggle-switch-animate switch-{$state}">
        <span class="switch-left"></span>
        <span class="knob"></span>
        <span class="switch-right"></span>
      </div>
    </div>
  </div>
</span>
EOF;
}

function help_popover($content){
    $content_fixed = str_replace('"', '&quot;' , $content);
  echo <<<EOF

<a tabindex="0"
  class="help"
  role="button"
  data-toggle="popover"
  data-trigger="focus"
  data-html="true"
  data-content="{$content_fixed}">
  <i class="fa fa-info-circle"></i>
</a>
EOF;
}

/* echo a child account's limit or the default if none is set */
function child_limit($conf, $child){
  if (is_null($conf['children']['limits'][$child])){
    echo(round($conf['children']['default_limit'] / 1024, 2));
  } else {
    echo(round($conf['children']['limits'][$child] / 1024, 2));
  }
}

/* show a hidden div that can be later shown to display an error */
function error_box($id, $class = "alert error-msg"){
  echo <<<EOF
  <div id="{$id}" class="{$class}"><i class="glyphicon glyphicon-exclamation-sign"></i><span></span></div>
EOF;
}

function browser_widget($browser_id, $home_path, $has_items_func, $post_action, $is_restore, $selections){
  if ($is_restore) {
    echo <<<EOF
  <div class="form-group row">
    <label class="col-sm-2 col-form-label text-right pad-top-6">Select Files</label>
    <div class="col-sm-10">
EOF;
  } else {
    echo <<<EOF
  <div class="form-group row">
    <div class="col-sm-12">
EOF;
  }
  $selections_encoded = htmlspecialchars(json_encode($selections));
  echo <<<EOF
      <div class="filebrowser-selectall">
        <button class="btn btn-sm" onclick="filebrowser_selectall('#{$browser_id}', true);">Select All</button>
        <button class="btn btn-sm" onclick="filebrowser_selectall('#{$browser_id}', false);">Deselect All</button>
        <div class="alert alert-danger browser-error hidden" id="{$browser_id}-errors">
            <i class="glyphicon glyphicon-exclamation-sign"></i> <span></span>
        </div>
      </div>
      <p>Click folders to expand them. Click checkboxes to select them to be restored.</p>
      <div id="{$browser_id}" data-errors="#{$browser_id}-errors" data-orig-selections="{$selections_encoded}" data-post-uri="./post.live.php" data-post-action="{$post_action}" data-home-path="{$home_path}" class="file_browse"></div>
    </div>
    <div class="row">
EOF;
  if ($is_restore) {
    echo <<<EOF
      <div class="col-sm-2"></div>
      <div class="col-sm-10">
EOF;
  } else {
    echo <<<EOF
      <div class="col-sm-12">
EOF;
  }
  echo <<<EOF
        <span class="count-zero"><span class="filebrowser-count" data-browser="#{$browser_id}" data-has-items-func="{$has_items_func}">0</span> items selected.</span>
      </div>
    </div>
  </div>
EOF;
}

function db_custom_select_widget($this_mode, $dbtype, $db_sizes, $db_conf){
  // Select all buttons
  echo <<<EOF
  <div class="custom-selectall">
    <button class="btn btn-sm" onclick="custom_db_selectall('#custom_items_{$this_mode}_{$dbtype}', true);">Select All</button>
    <button class="btn btn-sm" onclick="custom_db_selectall('#custom_items_{$this_mode}_{$dbtype}', false);">Deselect All</button>
  </div>
EOF;
  // Selection checkboxes
  echo("<div class=\"custom_items\" id=\"custom_items_{$this_mode}_{$dbtype}\">\n");
  ksort($db_sizes);
  foreach($db_sizes as $item => $size_mb) {
    if (is_null($size_mb)){
      $size_mb = '?';
    }
    echo("<div class=\"checkbox\">\n");
      if ( !is_null($db_conf['custom']) && in_array($item, $db_conf['custom']) ){ // item checked
        echo("<label><input type=\"checkbox\" class=\"custom_checkbox\" value=\"{$item}\" data-size=\"{$size_mb}\" data-oldval=\"y\" checked=\"checked\">");
      } else { // item unchecked
        echo("<label><input type=\"checkbox\" class=\"custom_checkbox\" value=\"{$item}\" data-size=\"{$size_mb}\" data-oldval=\"n\">");
      }
    label_size($item, $size_mb);
    echo("</label>\n</div>\n");
  }
  echo("</div>\n");
}

function selected_total_widget($baktype, $amp_url, $is_child){
  if ($is_child){
    $space_err_msg = "<p>The selected items cannot be backed up without additional space</p>";
  } else {
    $space_err_msg = "<p>The selected items won't be backed up unless you <a href=\"{$amp_url}\" target=\"_blank\">purchase more backup space</a>.</p>";
  }
  echo <<<EOF
  <div class="custom-total">
    <div class="row">
      <div class="col-sm-2">
        <strong>Total From Selected:</strong>
        <span class="total-selected-{$baktype}">0</span>GB
      </div>
      <div class="col-sm-2">
        <div class="progress">
          <div class="total-selected-bar progress-bar" role="progressbar" style="width: 0%"></div>
        </div>
      </div>
      <div class="col-sm-6">
        <div class="alert alert-danger total-selected-warning">
          <i class="glyphicon glyphicon-exclamation-sign"></i>
          {$space_err_msg}
        </div>
      </div>
    </div>
  </div>
EOF;
}

function date_select_label($conf, $geo, $time){
  if ($conf['show_geo']){
    if ($geo) {
      $name = $conf['geo_info']['name'];
    } else {
      $name = $conf['cluster_info']['name'];
    }
    return "$name - $time";
  } else {
    return "$time";
  }
}

?>
