<?php
if ( empty(get_included_files()) ) die("Direct access forbidden");
//sort custom items largest to smallest
arsort($conf['sizes'][$conf_key]);
if ($conf['bak_conf'][$conf_key]['hour'] == 0) {
  // midnight
  $hour = 12;
  $meridiem = 'AM';
} else if ($conf['bak_conf'][$conf_key]['hour'] == 12) {
  // noon
  $hour = 12;
  $meridiem = 'PM';
} else if ($conf['bak_conf'][$conf_key]['hour'] > 12) {
  // past noon
  $hour = $conf['bak_conf'][$conf_key]['hour'] - 12;
  $meridiem = 'PM';
} else {
  // after midnight, before noon
  $hour = $conf['bak_conf'][$conf_key]['hour'];
  $meridiem = 'AM';
}
?>
      <div class="panel panel-default"> <!-- settings tab <?php echo($section); ?> section -->
        <div class="panel-heading">
          <div class="row">
            <div class="col-sm-3"> <!-- backup type col -->
              <h4 class="panel-title">
                <a
                  data-toggle="collapse"
                  data-parent="#settings_accordion"
                  href="#settings_<?php echo($conf_key); ?>_collapse">
                    <span class="arw">&#9658;</span> <?php echo($section); ?>
                </a>
              </h4>
            </div>
            <div class="col-sm-3 text-center"> <!-- schedule col -->
              <h4 class="panel-title" id="sched_descr_<?php echo($conf_key); ?>">?</h4>
            </div>
            <div class="col-sm-3 text-center"> <!-- data backed up col -->
              <h4 class="panel-title" id="mode_descr_<?php echo($conf_key); ?>">?</h4>
            </div>
            <div class="col-sm-3 text-right"> <!-- current usage in GB -->
              <span class="usage_gb_<?php echo($conf_key); ?>">?</span>GB
            </div>
          </div>
        </div>
        <div id="settings_<?php echo($conf_key); ?>_collapse" class="panel-collapse collapse">
<?php if (array_key_exists($conf_key, $conf['completed']) && $conf['completed'][$conf_key]): ?>
          <p><strong>Backups Available</strong></p>
          <div class="well backups-available">
<?php   foreach($conf['completed'][$conf_key] as $snap): ?>
            <p>
              <span class="fix-locale-stamp"><?= $snap['time'] ?></span>
              <?php if ($conf_key == 'homedir'): ?>
                <a onclick="goto_restore(this);" data-geo="<?= $snap['geo'] ?>" data-baktype="<?= $conf_key ?>" data-snap="<?= $snap['snap'] ?>" href="#">Restore</a>
              <?php else: ?>
                <a onclick="goto_restore(this);" data-geo="<?= $snap['geo'] ?>" data-baktype="<?= $conf_key ?>" data-snap="<?= $snap['time'] ?>" href="#">Restore</a>
              <?php endif; ?>
            </p>
<?php   endforeach; ?>
        </div>
<?php endif; ?>
          <p><strong>Enable or Disable Backups</strong></p>
          <span
            class="hidden oldval-enable"
            data-oldval="<?php echo($conf['bak_conf'][$conf_key]['enable'] ? 'y' : 'n'); ?>"
            data-enableid="<?php echo("{$conf_key}_enabled"); ?>"
          ></span>
          <?php show_switch("{$conf_key}_enabled", $conf['bak_conf'][$conf_key]['enable']);
          if($conf['is_child']){
            help_popover(<<<EOF
Once Disabled, your "Backups Available" that are 30 days old or older will eventually be deleted.
If you'd like to keep your available backups, then before disabling, we recommend
restoring them to an alternate folder and downloading those files.
EOF
);
          }
          else {
            help_popover(<<<EOF
Once Disabled, your "Backups Available" that are 30 days old or older will eventually be deleted.
If you'd like to keep your available backups, then before disabling, we recommend
<a href="{$article_alt_folder}" target="_blank">restoring them to an alternate folder</a>
and downloading those files.
EOF
);
          }
?>
          <div id="settings_form_alert_<?php echo($conf_key); ?>" class="alert alert-warning">
            <i class="glyphicon glyphicon-exclamation-sign"></i> <p>Any <?php echo($section); ?> backups older than 30 days will be deleted.</p>
          </div>
          <div id="settings_form_<?php echo($conf_key); ?>" class="settings-form">
            <p><strong>Schedule Backups</strong></p>
            <div class="well"> <!-- schedule backups section -->
              <p>How often do you want your backups queued? We maintain the
              <strong><?php echo($conf['retention']); ?> most recent</strong>
              backups, and the oldest copy gets replaced when each scheduled backup performs. Once queued,
              the backups will be performed as soon as server workload allows.
              <?php
                if (! $conf['is_child']) {
                  $msg = "The number of retained backups is based on unused space";
                  if (! $conf['is_shared']) {
                    $msg = $msg . " on the server";
                  }
                  $msg = $msg . " and will be between 2 and 10.";
                  help_popover($msg);
                }
              ?>
            </p>
              <div class="radio"> <!-- by interval -->
                <label><input
                  type="radio" class="sched_radio" value="interval" name="scheduling_<?php echo($conf_key); ?>"
                  <?php if ($conf['bak_conf'][$conf_key]['use_interval']) { echo('data-oldval="y" checked="checked"');} ?>
                >By Interval</label>
              </div>
              <div class="form-group row indent-sched" id="sched_interval_form_<?php echo($conf_key); ?>">
                Backup every
                <input id="sched_interval_<?php echo($conf_key); ?>" type="number" min="1" max="30" value="<?php echo($conf['bak_conf'][$conf_key]['interval']); ?>"
                  class="form-control input-sm frm-sm sched_interval_input" data-error-id="#interval-error-<?php echo($conf_key); ?>" />
                Days
                <div class="alert alert-danger interval-error" id="interval-error-<?php echo($conf_key); ?>">
                  <i class="glyphicon glyphicon-exclamation-sign"></i> <p>The Backup Interval needs to be 1 Day or longer.</p>
                </div>
              </div>
              <div class="radio"> <!-- by day/time -->
                <label><input
                  type="radio" class="sched_radio" value="daily" name="scheduling_<?php echo($conf_key); ?>"
                  <?php if (! $conf['bak_conf'][$conf_key]['use_interval']) { echo('data-oldval="y" checked="checked"');} ?>
                >By Day/Time</label>
              </div>
              <div id="sched_daytime_form_<?php echo($conf_key); ?>">
                <div class="row indent-sched" id="scheduling_days_<?php echo($conf_key); ?>">
<?php $days = array('Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday');
      $day_short = array('M', 'Tu', 'W', 'Th', 'F', 'Sa', 'Su');
      foreach(array_values($days) as $index => $day): ?>
                  <label class="checkbox-inline">
                    <input type="checkbox" <?php
                    if (in_array($index, $conf['bak_conf'][$conf_key]['days'])) {
                      echo ('checked="checked" data-oldval="y"');
                    } else {
                      echo ('data-oldval="n"');
                    }
                    ?> value="<?php echo($index); ?>"
                    data-short="<?php echo($day_short[$index]); ?>" class="sched_days_checkbox"
                    ><?php echo($day); ?></input>
                  </label>
<?php endforeach; ?>
                </div>
                <div class="row indent-sched sched-time">
                  After
                  <input
                    id="scheduling_hour_<?php echo($conf_key); ?>"
                    type="number" value="<?php echo($hour); ?>"
                    min="1" max="12" data-oldval="<?php echo($hour); ?>"
                    class="form-control input-sm frm-sm sched_hour"
                  />
                  <select class="form-control input-sm frm-sm sched_meridiem" id="scheduling_meridiem_<?php echo($conf_key); ?>">
                    <option<?php if ($meridiem == 'AM'){ echo(' data-oldval="y" selected="selected"'); } ?>>AM</option>
                    <option<?php if ($meridiem == 'PM'){ echo(' data-oldval="y" selected="selected"'); } ?>>PM</option>
                  </select>
                </div>
              </div>
            </div>
          <p><strong>Data Included in Backup</strong></p>
          <div class="well"> <!-- custom backups section -->
            <p>What data do you want included in your backups?</p>
            <div class="radio">
              <label><input
                type="radio" class="custom_radio" value="all" name="mode_<?php echo($conf_key); ?>"
                <?php if (is_null($conf['bak_conf'][$conf_key]['mode'])){ echo('data-oldval="y" checked="checked"'); } ?>>
                <?php if ($conf_key == 'homedir'): ?>
                  All home directory folders
                <?php elseif (array_keys(['pgsql', 'mysql'], $conf_key)): ?>
                  <?php echo("All {$section} databases"); ?>
                <?php else : ?>
                  All Data
                <?php endif; ?>
              </label>
            </div>
<?php   if ($conf_key == 'homedir'): ?>
            <div class="radio">
              <label><input
                type="radio" class="custom_radio" value="whitelist" name="mode_<?php echo($conf_key); ?>"
                <?php if ($conf['bak_conf'][$conf_key]['mode'] == 'whitelist'){ echo('data-oldval="y" checked="checked"'); } ?>>
              Backup selected folders - When you create new folders they <strong><em>will not be</em></strong>
              backed up until also selected.</label>
              <?php help_popover("If you're not active in the root directory, choose backup selected folders."); ?>
              <div id="custom_hide_whitelist_homedir">
                <?php
                  if ($conf['bak_conf'][$conf_key]['mode'] == 'whitelist') {
                    $browser_selected = $conf['bak_conf'][$conf_key]['custom'];
                  } else {
                    $browser_selected = [];
                  }
                ?>
                <?php browser_widget('homedir-include-browser', $conf['home_path'], 'recalculate_usage', 'listdir', false, $browser_selected); ?>
                <?php selected_total_widget('homedir', $amp_url, $conf['is_child']) ?>
              </div>
            </div>
<?php   else: ?>
            <div class="radio">
              <label><input
                type="radio" class="custom_radio" value="whitelist" name="mode_<?php echo($conf_key); ?>"
                <?php if ($conf['bak_conf'][$conf_key]['mode'] == 'whitelist'){ echo('data-oldval="y" checked="checked"'); } ?>>
                Backup selected databases - When you create new databases they <strong><em>will not be</em></strong> backed up until also selected.</label>
            </div>
            <div id="custom_hide_whitelist_<?php echo($conf_key); ?>">
              <?php db_custom_select_widget('whitelist', $conf_key, $conf['sizes'][$conf_key], $conf['bak_conf'][$conf_key], $amp_url); ?>
              <?php selected_total_widget($conf_key, $amp_url, $conf['is_child']) ?>
            </div>
<?php   endif; ?>
<?php   if ($conf_key == 'homedir'): ?>
            <div class="radio">
              <label><input type="radio" class="custom_radio" value="blacklist" name="mode_homedir"
                <?php if ($conf['bak_conf'][$conf_key]['mode'] == 'blacklist'){ echo('data-oldval="y" checked="checked"'); } ?>>
                Exclude selected folders - When you create new folders they <strong><em>will be</em></strong>
                backed up.</label>
              <?php help_popover('If you are active in the root directory, we recommend excluding the selected folders.'); ?>
              <div id="custom_hide_blacklist_homedir">
              <?php
                  if ($conf['bak_conf'][$conf_key]['mode'] == 'blacklist') {
                    $browser_selected = $conf['bak_conf'][$conf_key]['custom'];
                  } else {
                    $browser_selected = [];
                  }
                ?>
                <?php browser_widget('homedir-exclude-browser', $conf['home_path'], 'recalculate_usage', 'listdir', false, $browser_selected); ?>
                <?php selected_total_widget('homedir', $amp_url, $conf['is_child']) ?>
              </div>
            </div>
<?php   else: ?>
            <div class="radio">
              <label><input
                type="radio" class="custom_radio" value="blacklist" name="mode_<?php echo($conf_key); ?>"
                <?php if ($conf['bak_conf'][$conf_key]['mode'] == 'blacklist'){ echo('data-oldval="y" checked="checked"'); } ?>>
                Exclude selected databases - When you create new databases they <strong><em>will be</em></strong> backed up.</label>
            </div>
            <div id="custom_hide_blacklist_<?php echo($conf_key); ?>">
              <?php db_custom_select_widget('blacklist', $conf_key, $conf['sizes'][$conf_key], $conf['bak_conf'][$conf_key], $amp_url); ?>
              <?php selected_total_widget($conf_key, $amp_url, $conf['is_child']) ?>
            </div>
<?php   endif; ?>
        </div>
          <div class="row settings-btn-row">
            <button id="<?php echo($conf_key); ?>-apply-btn" onclick="apply_settings('<?php echo($conf_key); ?>', this);" class="col-sm-2 btn btn-primary">Apply Changes</button>
            <div class="col-sm-1">
              <span class="cancel-link"><a onclick="cancel_settings(this);" href="#">Cancel</a></span>
            </div>
            <div class="col-sm-9">
              <?php error_box("{$conf_key}-apply-msg", "alert error-msg apply-msg"); ?>
            </div>
          </div>
        </div>
      </div>
    </div>
