"""Python/Nagios integration

.. data:: OK
.. data:: WARNING
.. data:: CRITICAL
.. data:: UNKNOWN
"""
import sys
from functools import wraps
from typing import NoReturn

OK = 0
OKAY = OK
WARNING = 1
CRITICAL = 2
UNKNOWN = 3


# the name arg used to be used for rads.lock()
def nrpe_lock(name=None):  # pylint: disable=unused-argument
    """Convenience decorator for NRPE scripts"""
    def decorator(func):
        @wraps(func)
        def wrapper(*args, **kwargs):
            try:
                return func(*args, **kwargs)
            except Exception as exc:
                print(type(exc).__name__, exc, sep=': ')
                sys.exit(UNKNOWN)

        return wrapper

    return decorator


def okay(*args, **kwargs) -> NoReturn:
    """Print a message and exit with OK status"""
    print(*args, **kwargs)
    sys.exit(OKAY)


def warning(*args, **kwargs) -> NoReturn:
    """Print a message and exit with WARNING status"""
    print(*args, **kwargs)
    sys.exit(WARNING)


def critical(*args, **kwargs) -> NoReturn:
    """Print a message and exit with CRITICAL status"""
    print(*args, **kwargs)
    sys.exit(CRITICAL)


def unknown(*args, **kwargs) -> NoReturn:
    """Print a message and exit with UNKNOWN status"""
    print(*args, **kwargs)
    sys.exit(UNKNOWN)


ok = okay
