"""Removes full cPanel backups residing in the homedir"""

from guds_modules.base import ModuleBase

REGEX = (
    r'.*\/(cpmove-[a-z]+([0-9]{1,3})?(.tar(.gz|$)|$)|'
    r'backup-[0-9]{1,2}[.][0-9]{1,2}[.][0-9]{4}_'
    r'[0-9]{1,2}-[0-9]{1,2}-[0-9]{1,2}_[a-z]+([0-9]{1,3})?.tar(.gz|$))'
)


class Module(ModuleBase):
    """Removes full cPanel backups residing in the homedir"""

    def run_module(self, homedir):
        if backup_list := self.find(
            homedir, maxdepth=1, mtime="+7", regex=REGEX
        ):
            self.delete_items(backup_list)
        return {}  # no email
