"""Core Dump Module for GRUDS"""

import os
import re
import time
import string
import rads
from guds_modules.base import ModuleBase

REGEX = r".*\/core\.([0-9]+)$"


class Module(ModuleBase):
    """Core Dump Module for GRUDS"""

    def run_module(self, homedir):
        dumplist = self.find(homedir, type='f', regex=REGEX)
        email = {}  # no email
        if not dumplist:
            return email
        # find newest dump
        if len(dumplist) > 2:
            newest = max(dumplist, key=os.path.getctime)
        else:
            newest = dumplist[0]
        # get age of dump
        age = int(time.time() - newest.stat().st_mtime)
        # if less than 48 hours old, get the cause to email the cx
        if age < 172800 and "mail" not in str(newest):
            self.logger.info(
                "%s is less than 48 hours old! Not deleted", newest
            )
            cause = get_cause(newest)
            affected_dir = os.path.dirname(newest)
            email = {
                'template': 363 if rads.IMH_CLASS == 'hub' else 109,
                'variable_1': affected_dir,
                'variable_2': cause,
            }
            dumplist.remove(newest)
        self.delete_items(dumplist)
        return email


def parse_coredump(coredump, buffer=4):
    with open(coredump, "rb") as dump:
        result = ""
        for char in dump.read():
            if char in string.printable:
                result += char
                continue
            if len(result) >= buffer:
                yield result
            result = ""


def get_cause(coredump):
    filename = ""
    try:
        for line in parse_coredump(coredump):
            if re.match("SCRIPT_FILENAME", line):
                columns = line.split('=')
                filename = columns[1]
    except Exception:
        return "unparseable coredump file"
    return filename
