"""Errors (and warnings) for cpapis"""


class CpAPIError(Exception):
    """Parent class for all errors running uapi/whmapi/cpapi"""

    __module__ = 'cpapis'


class CpAPIErrorMsg(CpAPIError):
    """Raised when an API executes and returns valid JSON, but the operation
    fails and reports a specific error message. This differs per API function"""

    __module__ = 'cpapis'

    def __init__(self, *, msg: str, data: dict):
        super().__init__(str(msg))
        self.data = data


class CpAPIExecFail(CpAPIError):
    """Raised when an API call fails to run at all by exiting non-zero, timing
    out or returning invalid JSON

    Attributes:
      cmd: The list or str args passed to run().
      returncode: The exit code of the process, negative for signals.
      stdout: The standard output
      stderr: The standard error
    """

    __module__ = 'cpapis'

    def __init__(
        self,
        *,
        msg: str,
        cmd: list[str],
        stdout: str,
        stderr: str,
        returncode: int,
    ):
        super().__init__(msg)
        self.cmd = cmd
        self.stdout = stdout
        self.stderr = stderr
        self.returncode = returncode


class CpAPIDeprecation(DeprecationWarning):
    """Subclass of DeprecationWarning for cpapis"""

    __module__ = 'cpapis'
