#!/bin/bash
input=$(cat)
user=$(echo "${input}" | jq -r '.data.user')
if [[ -z "${user}" ]]; then
    echo "Missing user, exiting.";
    exit 1;
fi
user_id=$(id -u "${user}")
if [[ -z "${user_id}" ]]; then
    echo "Missing user ID, exiting.";
    exit 1;
fi
echo "Reapplying LVE limits for ${user} (${user_id})";
/usr/sbin/lvectl apply "${user_id}"
