#!/opt/cloudlinux/venv/bin/python3 -bb
# -*- coding: utf-8 -*-

# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT

import sys
import time

import lvectllib
from clveconfig import ve_config


def create_backup(xml):
    BACK_IP_NAME = '/etc/container/ve.cfg.' + str(time.time())
    with open(BACK_IP_NAME, 'wb') as backup:
        backup.write(xml.toxml(encoding='utf-8'))


def main():
    lvectllib.get_global_lock(True)
    lvectllib.get_XML_cfg()
    if lvectllib.ve_cfg_version >= 2:
        # exit if already migrated
        sys.exit(0)
    create_backup(lvectllib.ve_cfg)
    ve_cfg_version = lvectllib.ve_lveconfig.getElementsByTagName('version')
    if len(ve_cfg_version) <= 0:
        # add ve_cfg_tag in config
        ve_cfg_vers = lvectllib.ve_cfg.createElement('version')
        ve_cfg_vers.appendChild(lvectllib.ve_cfg.createTextNode('2'))
        lvectllib.ve_lveconfig.appendChild(ve_cfg_vers)

    lvectllib.GetControlPanelUsers('list-packages')
    packages = lvectllib.packages_users.copy()

    for package in lvectllib.ve_package:
        found_in_standalone = False
        found_in_reseller = False
        if package.getAttribute('id') in packages:
            found_in_standalone = True
        reseller_list = lvectllib.guess_reseller_by_package(package.getAttribute('id'))
        if len(reseller_list) == 0:
            reseller = None
        elif len(reseller_list) == 1:
            reseller = reseller_list[0]
        else:
            found_in_reseller = True
        if (found_in_standalone and reseller is not None) or found_in_reseller :
            # dublicate found - skip this pkg
            print("Package " + str(package.getAttribute('id')) + " is duplicated. Skipped.")
            continue
        if reseller is not None:
            package.setAttribute('reseller', reseller)

    ve_config.save_xml(lvectllib.ve_cfg)


if __name__ == '__main__':
    main()
