import sys
from typing import Callable
import netaddr
from rads.color import green, red, bold, yellow


def err_exit(*args, file=sys.stderr, rcode=1, **kwargs):
    color_print(*args, color=red, file=file, **kwargs)
    sys.exit(rcode)


def warn(*args, file=sys.stderr, color: Callable = red, **kwargs):
    color_print(*args, color=color, file=file, **kwargs)


def print_listed(ipaddr: netaddr.IPAddress, listed: bool, where: str):
    """For printing whether an IP is listed in iptables"""
    print(
        f'The IP {ipaddr}',
        red('is listed') if listed else green('is not listed'),
        f'in {where}',
    )

def print_fail2ban_listed(ipaddr: netaddr.IPAddress, jail: str, ports: str):
    if 'ALL' in ports:
        blocked_on = 'ALL ports'
    else:
        blocked_on = f'ports {ports}'
    warn(
        f'Automatically blocked by fail2ban in the {jail} jail '
        f'on {red(blocked_on)}',
        color=yellow,
    )


def header(*args, color: Callable = bold, **kwargs):
    color_print(*args, color=color, **kwargs)


def color_print(*args, color: Callable = red, **kwargs):
    out = color(*args)
    if isinstance(out, str):
        print(out, **kwargs)
    else:
        print(*out, **kwargs)
