<?php
require "/usr/local/cpanel/php/cpanel.php";
$cpanel = new CPANEL();
$response = $cpanel->uapi(
  'IMHSpf',
  'imhspf',
  array(
    'args' => ''
  )
);
if ($response['cpanelresult']['result']['status'] === 1) { // uapi reported no errors
    try {
        $plugin_response = json_decode(
            $response['cpanelresult']['result']['data'],
            true, // associative
            512, //depth
            JSON_THROW_ON_ERROR // flags
        );
    } catch (Exception $exc) {
        $plugin_response = array(
            "status" => 255,
            "error" => 'PHP json_decode raised exception: ' . $exc->getMessage()
        );
    }
} else { // uapi reported errors
    $plugin_response = array(
        "status" => 255,
        "error" => 'cPanel uapi call reported an error: ' . json_encode($response['cpanelresult']['result']['errors'])
    );
}

header('Content-Type: application/json; charset=utf-8');
echo json_encode($plugin_response);
