<?php
ini_set('log_errors', 1);
error_reporting(E_ALL);
require "/usr/local/cpanel/php/cpanel.php";
// Print the base cpanel UI buttons at the top
$cpanel = new CPANEL();
print $cpanel->header('SPF Verification Tool - MailChannels');


?>
<link rel="stylesheet" type="text/css" href="./assets/spf.css?v=1.0.0.2" />
<script src="../libraries/jquery/current/jquery.min.js" type="text/javascript"></script>
<script src="../libraries/bootstrap/optimized/js/bootstrap.min.js" type="text/javascript"></script>
<script src="./assets//handlebars.min.js" type="text/javascript"></script>
<script type="text/javascript">
  // cPanel's jQuery will fight us; use no conflict mode
  var $j = jQuery.noConflict(false);

</script>


<script src="./assets/spf.js?v=1.0.0.2" type="text/javascript"></script>

<div class="alert alert-info">
    <p>This tool will check the SPF & MailChannels DNS records for all domains on your account. </p>
    <p>If you are sending email through this server, please review the recommendations for your domains.
    </p>
    <p>For additional information, please visit
    <a href="https://www.inmotionhosting.com/support/email/mailchannels/" target="_blank">our Support Center Articles.</a>
    </p>

</div>

<div class="row error__holder" id="check_error">
  <ul class="validation-container">
      <li class="validation validation-error">
          <i class="fas fa-exclamation-circle"></i>
          <span id="validator_checkerror" class="validation-message">
          </span>
      </li>
  </ul>
  <div class="retry-button">
    <button id="retry-checks" class="btn btn-primary btn-block">Run Check Again</button>
  </div>
</div>

<div id="loading-div">
    Running checks <i class="fa fa-spin fa-spinner"></i></div>
</div>

<div class="row accordion_legend">
  <div class="col-sm-3">
    <h4>Domains</h4>
  </div>
</div>
<div class="domain-border"></div>
<div class="panel-group" id="records_accordian">

</div>

<?php
print $cpanel->footer();
$cpanel->end();
?>

<script id="dns-template" type="text/x-handlebars-template">
  <div class="panel panel-default">
    <div class="panel-heading">
      <div class="row">
        <div class="col-sm-9">
          <h4 class="panel-title">
            {{#with domain}}
            <a data-toggle="collapse" data-parent="#records_accordian" href="#{{html_friendly}}_collapse">
            <span class="arw">&#9658;</span> {{name}}
            {{#with status}}
            <span class="record-status" title="{{title}}">
              <i class="fas {{icon}} {{class}}" ng-class="statusIconClass" aria-hidden="true"></i>
            </span>
            {{/with}}
            {{#each tags}}
            <span class="label {{class}}" title="{{description}}">{{name}}</span>
            {{/each}}
            {{/with}}
          </a>
          </h4>
        </div>
      </div>
    </div>
    <div id="{{domain.html_friendly}}_collapse" class="panel-collapse collapse">
      <div class="panel-body">
        <button class="copy-button copy-button-domain" data-value="{{domain.name}}">
              <i class="fas fa-copy"></i> Copy Domain
        </button>
        <div class="dns-section">

          {{#each dnsCheck}}
          <div class="dns-subsection">
            <div class="dns-title">
              <span>{{title}}</span>
            </div>
            <div class="dns-status">
              <div class="dns-current">
              {{#if current}}
                <div class="dns-inside">
                  <div class="dns-card">
                    {{#each current}}
                    <div class="dns-record-row">
                      <span class="dns-label">Value:</span>
                      <span class="dns-value">{{this}}</span>
                    </div>
                    {{/each}}
                    <div class="dns-record-note">
                      <span title="{{status.title}}">
                        <i class="fas {{status.icon}} {{status.class}}"></i>
                      </span>
                      {{status.title}}
                    </div>
                  </div>
                </div>
              {{/if}}
              </div>
            </div>
            {{#if recommended}}
            <div class="dns-recommended">
              <div class="dns-inside">
                <div class="dns-card">
                  <div class="dns-card-title">{{recommended.message}}</div>

                  <div class="dns-record-row">
                    <span class="dns-label">Type:</span>
                    <span class="dns-value">TXT</span>
                  </div>

                  <div class="dns-record-row">
                    <span class="dns-label">Name:</span>
                    <span class="dns-value">{{recommended.name}}</span>
                  </div>

                  <div class="dns-record-row">
                    <span class="dns-label">Value:</span>
                    <span class="dns-value">{{recommended.value}}</span>
                  </div>
                  <button class="copy-button" data-value="{{recommended.value}}">
                    <i class="fas fa-copy"></i> Copy Value
                  </button>

                  <div class="dns-record-note">
                    {{recommended.note}}
                  </div>
                </div>
              </div>
            </div>
            {{/if}}
          </div>
          {{/each}}

        </div>
      </div>
    </div>
  </div>
</script>
