<?php
/**
 * @package themify
 * @since 1.1.1.0
 * 
 * ----------------------------------------------------------------------
 * 					DO NOT EDIT THIS FILE
 * ----------------------------------------------------------------------
 * 				Class to interact with TinyMCE editor. 
 *  			http://themify.me
 *  			Copyright (C) Themify
 *
 ***************************************************************************/

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Themify_TinyMCE {
	
	function __construct(){
		defined( 'THEMIFY_TINYMCE_URI' ) or define( 'THEMIFY_TINYMCE_URI', THEMIFY_URI . '/tinymce/' );

		if ( current_user_can( 'publish_posts' ) && get_user_option( 'rich_editing' ) === 'true' ) {
			add_filter( 'mce_external_plugins', array( $this, 'add_plugin' ) );
			add_filter( 'mce_buttons', array( $this, 'add_button' ) );
			add_action( 'wp_enqueue_scripts', array( $this, 'localize' ) );
			add_action( 'admin_enqueue_scripts', array( $this, 'localize' ) );
			add_action( 'print_media_templates', array( $this, 'print_media_templates' ) );
		}
	}

	/**
	 * Add button to WP Editor.
	 *
	 * @param array $mce_buttons
	 * @return mixed
	 */
	function add_button( $mce_buttons ) {
		$mce_buttons[] = 'separator';
		$mce_buttons[] = 'btnthemifyMenu';
		return $mce_buttons;
	}

	/**
	 * Add plugin JS file to list of external plugins.
	 *
	 * @param array $mce_external_plugins
	 * @return mixed
	 */
	function add_plugin( $mce_external_plugins ) {
		$mce_external_plugins['themifyMenu'] = themify_enque(THEMIFY_TINYMCE_URI . 'plugin.js');

		return $mce_external_plugins;
	}

	/**
	 * Get list of Themify shortcodes and their config
	 *
	 * @since 2.7.6
	 */
	function get_shortcodes() {
		$shortcodes = apply_filters( 'themify_shortcodes', include( dirname( __FILE__ ) . '/shortcodes.php' ) );

		/* sort list of shortcodes by their priority key */
		uasort( $shortcodes, array( $this, 'sort_by_priority_key' ) );

		/* sort the fields array in each shortcode */
		foreach( $shortcodes as $key => $def ) {
			if(! empty( $shortcodes[$key]['fields'] ) ){
				usort( $shortcodes[$key]['fields'], array( $this, 'sort_by_priority_key' ) );
			}
		}

		return $shortcodes;
	}

	/**
	 * Pass strings to JS to set the labels of the WP Editor shortcode button and menu.
	 *
	 * @since 1.8.9
	 */
	function localize() {
		wp_localize_script( 'editor', 'themifyEditor', array(
			'nonce' => wp_create_nonce( 'themify-editor-nonce' ),
			'shortcodes' => $this->get_shortcodes(),
			'editor' => array(
				'menuTooltip' => __('Shortcodes', 'themify'),
				'menuName' => __('Shortcodes', 'themify'),
				'icon' => THEMIFY_TINYMCE_URI . 'icon.png',
			)
		));
	}

	/**
	 * Print template files that will generate the shortcode code
	 *
	 * @since 2.7.6
	 */
	function print_media_templates( $shortcodes = null ) {
		if( $shortcodes == null ) {
			$shortcodes = $this->get_shortcodes();
		}
		foreach( $shortcodes as $key => $shortcode ) {
			if( isset( $shortcode['menu'] ) ) {
				$this->print_media_templates( $shortcode['menu'] );
			} else {
				echo '<script type="text/html" id="tmpl-themify-shortcode-' . $key . '">';
				if( isset( $shortcode['template'] ) ) {
					echo $shortcode['template'];
				} else {
					// generate the shortcode template based on parameters
					echo '[' . $key;
					if( isset( $shortcode['fields'] ) ) {
						foreach( $shortcode['fields'] as $field ) {
							if( isset( $field['ignore'] ) ) {
								continue;
							} else {
								echo '<# if ( data.' . $field['name'] . ' ) { #> ' . $field['name'] . '="{{data.' . $field['name'] . '}}"<# } #>';
							}
						}
					}
					echo ']';
					if( !empty( $shortcode['closing_tag'] )) {
						echo isset( $shortcode['wrap_with'] ) ? $shortcode['wrap_with'] : '{{{data.selectedContent}}}';
						echo '[/' . $key . ']';
					}
				}
				echo '</script>';
			}
		}
	}

	/**
	 * Callback for usort and uasort, sorts the array by the 'priority' key
	 * Default priority for all keys is 10
	 *
	 * @return int
	 */
	function sort_by_priority_key( $item1, $item2 ) {
		$i1p = isset( $item1['priority'] ) ? $item1['priority'] : 10;
		$i2p = isset( $item2['priority'] ) ? $item2['priority'] : 10;
		if( $i1p == $i2p ) return 0;

		return $i1p < $i2p ? -1 : 1;
	}
}

/**
 * Initialize class to add button to WP Editor.
 */
function themify_init_tinymce() {
	new Themify_TinyMCE();
}
add_action( 'init', 'themify_init_tinymce' );