"""
Networking interfaces functions
"""

import subprocess
import netifaces
from netaddr import IPNetwork,IPAddress

def get_frontlan():
    """ return the name of the front lan interface """
    return netifaces.gateways()['default'].items()[0][1][1]

def get_backlan():
    interface_list = netifaces.interfaces()
    for iface in interface_list:
        try:
            ip = netifaces.ifaddresses(iface)[netifaces.AF_INET][0]['addr']
        except:
            ip = ''
        try:
            if IPAddress(ip).is_private():
                return iface
        except:
            pass
