"""Python/Nagios integration"""
import sys
from functools import wraps
from rads.context import s_lock
from rads.exceptions import S_LockError
import __main__ as main_obj

OK = 0
WARNING = 1
CRITICAL = 2
UNKNOWN = 3

def nrpe_lock_critical():
    """Function to exit with critical for failures in
    rads.common.get_socket_lock. This is a common function so
    all of our plugins print the same output."""
    print 'CRITICAL - duplicate nrpe plugin running. Kill %s' % main_obj.__file__
    sys.exit(CRITICAL)

def nrpe_lock(name=None):
    """Convenience decorator for NRPE scripts. Rather than use s_lock, throw
    @nrpe_lock at the top of main() in your NRPE script and it will
    handle locking for you as well as call nrpe_lock_critical() if it cannot.
    Like s_lock, it can optionally accept a name for the socket.

    Usage example:

    @nrpe_lock()
    def main():
        pass # put your nrpe script logic in here

    if __name__ == '__main__':
        main()
"""
    def decorator(func):
        @wraps(func)
        def wrapper(*args, **kwargs):
            try:
                with s_lock(name):
                    return func(*args, **kwargs)
            except S_LockError:
                nrpe_lock_critical()
            except Exception as exc:
                print exc
                sys.exit(UNKNOWN)
        return wrapper
    return decorator
