#!/opt/alt/python37/bin/python3 -bb
# coding=utf-8
#
# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT
from __future__ import print_function
from __future__ import absolute_import
try:
    from dbmigrate_lib import alembic_migrate
    from lvestats.lib.dbengine import make_db_engine
    from lvestats.lib.config import read_config
except ImportError as e:
    print('Can\'t migrate database; {}'.format(e))
    exit(1)

from clcommon.lib.cledition import lve_supported_or_exit


@lve_supported_or_exit
def main(config, _engine):
    alembic_migrate(_engine, lve_stats_cfg=config)


if __name__ == '__main__':
    cnf = read_config()
    engine = make_db_engine(cnf)
    main(cnf, engine)
