#!/opt/maint/venv/bin/python3
"""Removes old suspension locks"""
# Vanessa V 3/9/16

import sys
from pathlib import Path

SUSPEND_DIR = Path('/var/cpanel/suspended')
USER_DIR = Path('/var/cpanel/users')


def main():

    if not SUSPEND_DIR.is_dir():
        sys.exit(0)

    for path in SUSPEND_DIR.glob('*.lock'):
        user = path.name[:-5]
        # Check that each lock file has a user associated with it
        if not (USER_DIR / user).exists():
            path.unlink()


if __name__ == '__main__':
    main()
