#!/bin/bash
# Shared RADS Tools, written by Erik Soroka (eriks@imhadmin.net, ext 834)
# this script gets executed by crontab to collect sa accounting data for use by RADS tools

    #lets set some variables
    YEAR=$(date '+%Y')
    MONTH=$(date '+%b')
    NUMMONTH=$(date '+%m')
    DAY=$(date '+%d')
    HOUR=$(date '+%H')

    #create appropriate directories
    mkdir -p "/var/log/sa/rads/$MONTH/$DAY"
    mkdir -p /var/log/sa/rads/diskavail/
    mkdir -p /var/log/sa/rads/diskused/

#####################################################################
###        COLLECT AND ARCHIVE PROCESS ACCOUNTING DATA HERE
#####################################################################

    #output summary to file
    /usr/sbin/sa -mc > "/var/log/sa/rads/$MONTH/$DAY/$HOUR-avg"

    #output totals to file
    /usr/sbin/sa -u > "/var/log/sa/rads/$MONTH/$DAY/$HOUR"

    #compress files for optimal archival
    gzip -f "/var/log/sa/rads/$MONTH/$DAY/$HOUR-avg"
    gzip -f "/var/log/sa/rads/$MONTH/$DAY/$HOUR"

#####################################################################
###        FRESHEN YESTERDAY'S DATA. T3 TRAC #112
#####################################################################

    YESTERDAY_DAY=$(date --date='1 day ago' '+%d')
    YESTERDAY_MON=$(date --date='1 day ago' '+%b')
    YESTERDAY_YEAR=$(date --date='1 day ago' '+%Y')
    YESTERDAY_FIN_AVG='/var/log/sa/rads/'$YESTERDAY_MON'/'$YESTERDAY_DAY'/99-avg.gz'

    #Which file has yesterday's data? CE6 uses a different naming convention
    ACCT_FILES[0]='/var/account/pacct.1'
    ACCT_FILES[1]="/var/account/pacct-${YEAR}${NUMMONTH}${DAY}"

    # Find the one that exists
    for ACCT_FILE in "${ACCT_FILES[@]}"; do
        if [[ -f $ACCT_FILE ]]; then
            YESTERDAY_ACCT_FILE=$ACCT_FILE
        fi
    done

    #time's %s format doesn't return a float on anything I tested on, but
    #just in case, we'll pipe to cut
    YESTERDAY_ACCT_MTIME=$(date -r "$YESTERDAY_ACCT_FILE" '+%s' | cut -d. -f1)
    YESTERDAY_11TH_HOUR=$(date --date="$YESTERDAY_MON $YESTERDAY_DAY $YESTERDAY_YEAR 23:59" '+%s' | cut -d. -f1)

    #if yesterday's acct file's mtime is not null (it would be if the file didn't exist)
    if [[ ! -z $YESTERDAY_ACCT_MTIME \
    #and yesterday's acct file has been modified since 23:59 yesterday
    && $YESTERDAY_ACCT_MTIME -gt $YESTERDAY_11TH_HOUR \
    #and the final -avg.gz file doesn't already exist
    && ! -f $YESTERDAY_FIN_AVG \
    #and a folder already exists for yesterday's saved sa data
    && -d '/var/log/sa/rads/'$YESTERDAY_MON'/'$YESTERDAY_DAY ]]; then
        /usr/sbin/sa -mc -f "$YESTERDAY_ACCT_FILE" | gzip -c > "$YESTERDAY_FIN_AVG"
    fi

#####################################################################
###        COLLECT AND ARCHIVE DISK SPACE ACCOUNTING DATA HERE
#####################################################################

    #built in logic for varying partition tables across the shared fleet
    AREWEHOME=$(/bin/df | /bin/grep '% /home$')

    if [ -z "$AREWEHOME" ]; then
        /bin/df | /bin/grep '% /$' | awk '{print $1,$4,$5}' > "/var/log/sa/rads/diskavail/$DAY"
        /bin/df | /bin/grep '% /$' | awk '{print $1,$3,$5}'  > "/var/log/sa/rads/diskused/$DAY"
    else
        /bin/df | /bin/grep '% /home$' | awk '{print $1,$4,$5}' > "/var/log/sa/rads/diskavail/$DAY"
        /bin/df | /bin/grep '% /home$' | awk '{print $1,$3,$5}'  > "/var/log/sa/rads/diskused/$DAY"
    fi

#####################################################################
###      CHECK FOR YUM SYSTEM UPDATES FOR LATER MONITORING
#####################################################################

/usr/bin/yum check-update > /var/run/yum.check-update
chown nagios.nagios /var/run/yum.check-update

#####################################################################
###      CHECK FOR DEFACEMENTS FROM ZONE-H FOR LATER MONITORING
#####################################################################

TODAYIS=$(date +%Y/%m/%d)
MAINIPS=$(awk --re-interval '/[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}/{print $0}' /var/cpanel/mainip /var/cpanel/mainips/root | sort | uniq)
true > /var/log/.defacecounter
for IPADDR in $MAINIPS; do
     HITS=$(curl --connect-timeout 10 -s "http://www.zone-h.org/archive/ip=$IPADDR" | grep -c "$TODAYIS")
     echo "$HITS $IPADDR" >> /var/log/.defacecounter
done


#####################################################################
### CHECK FOR OVERSIZED DOMLOGS AND SEND IN STR'S FOR ACTION
#####################################################################

/opt/sharedrads/extras/large_log_audit.sh 1>/dev/null 2>/dev/null

#####################################################################
###        ERROR CHECKING AND REPORTING
#####################################################################

if [ -d "/var/log/sa/rads/$MONTH/$DAY" ]; then
    echo "OK"
else
    echo "SA data runner failed to create archive directory: /var/log/sa/rads/$MONTH/$DAY -- Please investigate" | /opt/sharedrads/strmailer -u root -e sadmin@imhadmin.net -s "sadatarunner error: $(hostname -s)"
fi

## EOF ##
