"""Functions for colorizing console text

    Example individually coloring a print argument:
        ``print(rads.color.red('test'))``
    Example coloring a list and using star-args to print:
        ``print(*rads.color.red('a', 'b'))``
"""

from typing import Union
from collections.abc import Iterable


def _colorize(*args: Union[str, Iterable], color: str) -> Union[str, Iterable]:
    out = [f'{color}{x}\033[0m' for x in args]
    if not out:
        return ''
    if len(out) == 1:
        return out[0]
    return out


def red(*args: Union[str, Iterable]) -> Union[str, Iterable]:
    """Color console text red

    Args:
        args: text to colorize
    """
    return _colorize(*args, color='\33[91;1m')


def green(*args: Union[str, Iterable]) -> Union[str, Iterable]:
    """Color console text green

    Args:
        args: text to colorize
    """
    return _colorize(*args, color='\033[92;1m')


def yellow(*args: Union[str, Iterable]) -> Union[str, Iterable]:
    """Color console text yellow

    Args:
        args: text to colorize
    """
    return _colorize(*args, color='\033[93;1m')


def blue(*args: Union[str, Iterable]) -> Union[str, Iterable]:
    """Color console text blue

    Args:
        args: text to colorize
    """
    return _colorize(*args, color='\033[94;1m')


def magenta(*args: Union[str, Iterable]) -> Union[str, Iterable]:
    """Color console text magenta

    Args:
        args: text to colorize
    """
    return _colorize(*args, color='\033[95m')


def cyan(*args: Union[str, Iterable]) -> Union[str, Iterable]:
    """Color console text cyan

    Args:
        args: text to colorize
    """
    return _colorize(*args, color='\033[96m')


def bold(*args: Union[str, Iterable]) -> Union[str, Iterable]:
    """Color console text bold

    Args:
        args: text to colorize
    """
    return _colorize(*args, color='\033[1m')


def underline(*args: Union[str, Iterable]) -> Union[str, Iterable]:
    """Color console text underline

    Args:
        args: text to colorize
    """
    return _colorize(*args, color='\033[4m')


def invert(*args: Union[str, Iterable]) -> Union[str, Iterable]:
    """Color console text inverted

    Args:
        args: text to colorize
    """
    return _colorize(*args, color='\033[7m')
