"""cpapi1 functions"""
from typing import Union
import warnings
from ._errors import CpAPIDeprecation
from ._base import CpAPIBase


class Cpapi1(CpAPIBase):
    """cpapi1 functions"""

    __module__ = 'cpapis'

    def __init__(self):
        if self._can_exec('/usr/bin/cpapi1'):
            super().__init__('/usr/bin/cpapi1')
        else:
            super().__init__('/usr/local/cpanel/bin/cpapi1')

    def __call__(
        self,
        module: str,
        user: Union[str, None] = None,
        args: Union[dict, None] = None,
        timeout: Union[float, None] = None,
    ):
        """Query cpapi1

        Args:
            module: the cpapi1 module to use in format x::y
            user: ``--user`` arg to use
            args: key-vals to send to cpapi1
            timeout: timeout for the cpapi1 command in secs
        """
        warnings.warn(
            'cpapi1 is deprecated. Use cpapi2 or uapi', CpAPIDeprecation
        )
        return self._exec(
            module_args=module.split('::'),
            user=user,
            args=args,
            timeout=timeout,
        )
