#!/opt/maint/venv/bin/python3
"""Adds cPanel users to a common supplementary group"""
import grp
from subprocess import check_call, CalledProcessError
import rads

COMMON_GROUP = 'cpanel-users'


def main():
    # cron config appends stdout/err to /var/log/maint/secgroups.log
    logger = rads.setup_logging(
        path=None,
        print_out='stdout',
        name='secgroup',
        loglevel='INFO',
        fmt='%(asctime)s [%(levelname)s] %(message)s',
    )

    cpanel_users = set(rads.all_cpusers())
    group_members = grp.getgrnam(COMMON_GROUP).gr_mem
    missing_users = cpanel_users.difference(group_members)

    for user in missing_users:
        logger.info('%s not in %s', user, COMMON_GROUP)
        try:
            check_call(['usermod', '-G', COMMON_GROUP, user])
        except CalledProcessError:
            logger.critical('Failed to add %s to %s', user, COMMON_GROUP)
        else:
            logger.info('Added %s to %s', user, COMMON_GROUP)


if __name__ == '__main__':
    main()
