from typing import Union
import os

is_exe = lambda x: os.path.isfile(x) and os.access(x, os.X_OK)


def cpuwatch_execv(args: list[str]):
    """os.execv a command with cpuwatch"""
    cores = os.cpu_count()
    assert cores
    cmd = ["/usr/local/cpanel/bin/cpuwatch", str(cores)]
    cmd.extend(args)
    os.execv(cmd[0], cmd)


def which(executable: str) -> Union[str, None]:
    for path in os.get_exec_path():
        full = os.path.join(path, executable)
        if is_exe(full):
            return full
    return None
