# Test if interactive
if [ "${PS1}" ]; then
    # If root
    if [ "$EUID" -eq 0 ]; then
        export PATH="${PATH}:/opt/tier1adv/bin"
    # elif any staff group
    elif id -Gn | grep -qP '@ipa.imhtech.net'; then
        export PATH="${PATH}:/opt/tier1adv/bin"
        alias switch='sudo /opt/tier1adv/bin/switch'
        alias addlocaldomain='sudo /opt/tier1adv/bin/addlocaldomain'
        alias checkip="sudo /opt/tier1adv/bin/checkip"
        alias chmod="sudo /opt/tier1adv/bin/chownmod.py chmod"
        alias chown="sudo /opt/tier1adv/bin/chownmod.py chown"
        alias help="/bin/more -d /home/tier1adv/.helpfile"
        alias loghelp="/bin/more -d /home/tier1adv/.helplog"
        alias mailhelp="/bin/more -d /home/tier1adv/.helpmail"
        alias homedirscan="sudo /opt/tier1adv/bin/homedirscan"
        alias passwd="sudo /opt/tier1adv/bin/chpass"
        alias rmpwb="sudo /opt/tier1adv/bin/rmpwb"
        alias unblock="sudo /opt/tier1adv/bin/unblock"
        alias usernano="sudo /opt/tier1adv/bin/usernano"
        alias singlefilescan="sudo /opt/tier1adv/bin/singlefilescan"
        alias rmlocaldomain="sudo /opt/tier1adv/bin/rmlocaldomain"
        alias check_downgrade="sudo /opt/tier1adv/bin/check_downgrade"
        alias cms-password="sudo /opt/tier1adv/bin/cms-password"
        alias validate_zone="sudo /opt/tier1adv/bin/validate_zone"
        alias safe_pkgacct="sudo /opt/tier2c/safe_pkgacct.py"
        # Test if in the tier1adv or tier2c groups
        if id -Gn | grep -qP '\b(?:tier1adv|tier2c)\b'; then
            # Custom support MOTD
            echo "Type 'help' for basic information on commands"
            echo -e "\e[34m$(cat /etc/redhat-release) \e[0m\n"
        fi
        # Test if in the tier2c or systems groups
        if id -Gn | grep -qP '\b(systems|tier2s|engineering|tier1e|aps|tier3)@ipa.imhtech.net'; then
            alias mv_backup="sudo /opt/tier2c/mv_backup.py"
            alias safe_removeacct="sudo /opt/tier2c/safe_removeacct.py"
            alias safe_restorepkg="sudo /opt/tier2c/safe_restorepkg.py"
        fi
    fi
fi
